<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Invoice_<?php echo e($order->invoice_no); ?></title>
    <style>
        @page {
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Helvetica', 'Arial', sans-serif;
            font-size: 12px;
            color: #0f172a;
            margin: 0;
            padding: 0;
            line-height: 1.3;
        }

        .page-container {
            padding: 20px 30px;
        }

        /* --- Header --- */
        .header-section {
            width: 100%;
            border-bottom: 2px solid #0f172a;
            padding-bottom: 5px;
            margin-bottom: 10px;
        }

        .company-name {
            font-size: 24px;
            font-weight: 800;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 2px;
            color: #000;
        }

        .company-sub {
            font-size: 10px;
            color: #334155;
            line-height: 1.3;
        }

        .invoice-title {
            font-size: 22px;
            font-weight: 700;
            text-transform: uppercase;
            text-align: right;
            color: #000;
        }

        .invoice-meta {
            text-align: right;
            font-size: 11px;
            color: #334155;
            margin-top: 2px;
        }

        /* --- Info Grid (Compact) --- */
        .info-table {
            width: 100%;
            margin-bottom: 10px;
            border-spacing: 10px;
            margin-left: -10px;
            width: calc(100% + 20px);
        }

        .info-box {
            width: 50%;
            vertical-align: top;
            padding: 8px;
            border: 1px solid #0f172a;
            border-radius: 4px;
        }

        .info-label {
            font-size: 10px;
            text-transform: uppercase;
            color: #000;
            font-weight: 800;
            margin-bottom: 2px;
            border-bottom: 1px solid #0f172a;
            padding-bottom: 2px;
            display: block;
        }

        .box-content {
            font-size: 11px;
            line-height: 1.3;
        }

        /* --- Items Table --- */
        .items-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 11px;
            margin-bottom: 10px;
        }

        .items-table th {
            padding: 6px 4px;
            border-bottom: 2px solid #0f172a;
            border-top: 1px solid #e2e8f0;
            color: #000;
            font-weight: 700;
            text-transform: uppercase;
            font-size: 10px;
        }

        .items-table td {
            padding: 6px 4px;
            border-bottom: 1px solid #e2e8f0;
            color: #334155;
        }

        .text-right {
            text-align: right !important;
        }

        .text-center {
            text-align: center !important;
        }

        .text-left {
            text-align: left !important;
        }

        .font-bold {
            font-weight: 700;
            color: #000;
        }

        /* --- Totals --- */
        .totals-container {
            border-top: 2px solid #0f172a;
            padding-top: 10px;
            page-break-inside: avoid;
        }

        .totals-table {
            width: 100%;
            border-collapse: collapse;
        }

        .totals-table td {
            padding: 2px 0;
            font-size: 11px;
        }

        .final-row td {
            font-size: 13px;
            font-weight: 800;
            color: #000;
            border-top: 1px solid #0f172a;
            padding-top: 5px;
        }

        .terms-box {
            font-size: 9px;
            color: #475569;
            padding-right: 10px;
        }

        .terms-title {
            font-weight: 700;
            text-transform: uppercase;
            margin-bottom: 2px;
            color: #000;
        }

        footer {
            position: fixed;
            bottom: -30px;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 8px;
            color: #94a3b8;
            height: 15px;
            border-top: 1px solid #e2e8f0;
            padding-top: 5px;
        }

        /* Payment Status Styles - Colored */
        .status-text {
            font-weight: 800;
            text-transform: uppercase;
            padding: 2px 5px;
            border-radius: 3px;
        }

        .status-paid {
            color: #16a34a;
            border: 1px solid #16a34a;
        }

        .status-partial {
            color: #ea580c;
            border: 1px solid #ea580c;
        }

        .status-unpaid {
            color: #dc2626;
            border: 1px solid #dc2626;
        }

        /* Bank Details Box */
        .bank-details-box {
            margin-top: 10px;
            border: 1px dashed #cbd5e1;
            padding: 8px;
            border-radius: 4px;
            background-color: #f8fafc;
            display: inline-block;
        }
    </style>
</head>

<body>
    <footer>Generated on <?php echo e(now()->format('d M, Y h:i A')); ?> • <?php echo e($settings['company_name'] ?? 'Maa Trader'); ?></footer>

    <div class="page-container">

        <!-- Header Section -->
        <table class="header-section">
            <tr>
                <td width="60%" style="vertical-align: top;">
                    <div class="company-name"><?php echo e($settings['company_name'] ?? 'Maa Trader'); ?></div>
                    <div class="company-sub">
                        <?php echo e($settings['company_address'] ?? 'Orma Highway, Siwan - 841236'); ?><br>
                        Phone: <?php echo e($settings['company_phone'] ?? '+91 99999 99999'); ?><br>
                        <?php if($order->tax_amount > 0): ?>
                            GSTIN: <?php echo e($settings['company_gst'] ?? 'XXXXXXXXX'); ?>

                        <?php endif; ?>
                    </div>
                </td>
                <td width="40%" style="vertical-align: top;">
                    <div class="invoice-title">Invoice</div>
                    <div class="invoice-meta">
                        <strong>#<?php echo e($order->invoice_no); ?></strong><br>
                        Date: <?php echo e(\Carbon\Carbon::parse($order->invoice_date)->format('d M, Y')); ?><br>

                        <!-- Colored Status -->
                        <div style="margin-top: 5px;">
                            <?php if($order->payment_status == 'PAID'): ?> <span class="status-text status-paid">PAID</span>
                            <?php elseif($order->payment_status == 'PARTIAL'): ?> <span
                                class="status-text status-partial">PARTIAL</span>
                            <?php else: ?> <span class="status-text status-unpaid">UNPAID</span> <?php endif; ?>
                        </div>
                    </div>
                </td>
            </tr>
        </table>

        <!-- Info Grid -->
        <table class="info-table">
            <tr>
                <td class="info-box">
                    <span class="info-label">Bill To</span>
                    <div class="box-content">
                        <div style="font-weight: 700; font-size: 12px; margin-bottom: 1px;"><?php echo e($order->customer_name); ?>

                        </div>
                        <div><?php echo e($order->customer->address ?? ''); ?></div>
                        <div style="margin-top: 2px;">
                            Ph: <strong><?php echo e($order->customer->phone ?? $order->customer_phone ?? 'N/A'); ?></strong>
                        </div>
                    </div>
                </td>
                <td class="info-box">

                    <span class="info-label">Bank Details & Pay</span>
                    <div class="box-content">
                        <?php if(isset($bankAccount) && $bankAccount): ?>
                            <table style="width: 100%; border-collapse: collapse;">
                                <tr>
                                    <td style="vertical-align: top; font-size: 10px;">
                                        <div style="margin-bottom: 2px;">Bank:
                                            <strong><?php echo e($bankAccount->bank_name); ?></strong>
                                        </div>
                                        <div style="margin-bottom: 2px;">A/c:
                                            <strong><?php echo e($bankAccount->account_number); ?></strong>
                                        </div>
                                        <div style="margin-bottom: 2px;">IFSC:
                                            <strong><?php echo e($bankAccount->ifsc_code); ?></strong>
                                        </div>
                                        <div style="margin-bottom: 2px;">Name:
                                            <strong><?php echo e($bankAccount->account_name); ?></strong>
                                        </div>
                                    </td>
                                    <?php if($bankAccount->upi_id && ($order->net_amount - $order->paid_amount) > 0.01): ?>
                                        <td style="vertical-align: top; text-align: right; width: 65px;">
                                            <?php
                                                $balance = $order->net_amount - $order->paid_amount;
                                                $upiString = "upi://pay?pa={$bankAccount->upi_id}&pn=" . urlencode($bankAccount->account_name) . "&am={$balance}&tn=Inv-{$order->invoice_no}";
                                                $qrUrl = "https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=" . urlencode($upiString);
                                            ?>
                                            <img src="<?php echo e($qrUrl); ?>" style="width: 60px; height: 60px;" alt="QR" />
                                        </td>
                                    <?php endif; ?>
                                </tr>
                            </table>
                        <?php else: ?>
                            <div style="color: #94a3b8; font-style: italic;">(No Bank Configured)</div>
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
        </table>

        <!-- Items Table -->
        <table class="items-table">
            <thead>
                <tr>
                    <th width="8%" class="text-center">#</th>
                    <th width="50%" class="text-left">Description</th>
                    <th width="12%" class="text-right">Price</th>
                    <th width="10%" class="text-right">Qty</th>
                    <th width="20%" class="text-right">Total</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="text-center"><?php echo e($index + 1); ?></td>
                        <td class="text-left">
                            <div style="font-weight: 700; color: #0f172a; font-size: 11px;">
                                <?php echo e($item->size_name ?? 'N/A'); ?> <?php echo e($item->sub_size_name ?? ''); ?>

                                <span style="font-size: 9px; color: #64748b; font-weight: 400; margin-left: 5px;">
                                    (Batch: <?php echo e($item->batch_no); ?>)
                                </span>
                            </div>
                        </td>
                        <td class="text-right"><?php echo e(number_format($item->price_per_piece, 2)); ?></td>
                        <td class="text-right"><?php echo e($item->quantity_pieces); ?></td>
                        <td class="text-right font-bold"><?php echo e(number_format($item->total_price, 2)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <!-- Totals & Banking -->
        <div class="totals-container">
            <table width="100%">
                <tr>
                    <td width="60%" style="vertical-align: top; padding-right: 20px;">

                        <!-- Terms -->
                        <div class="terms-box">
                            <div class="terms-title">Terms & Conditions</div>
                            <ol style="margin: 0; padding-left: 15px; margin-top: 2px;">
                                <li>All disputes are Subject to Siwan Jurisdiction only.</li>
                            </ol>
                        </div>

                        <!-- Bank Details & QR -->
                        <div style="margin-top: 10px; font-size: 9px; color: #94a3b8; font-style: italic;">
                            
                        </div>
                    </td>

                    </td>
                    <td width="40%" style="vertical-align: top;">
                        <table class="totals-table">
                            <tr>
                                <td>Sub Total</td>
                                <td class="text-right"><?php echo e(number_format($order->total_amount, 2)); ?></td>
                            </tr>
                            <?php if($order->tax_amount > 0): ?>
                                <tr>
                                    <td>GST (<?php echo e($order->gst_rate); ?>%)</td>
                                    <td class="text-right"><?php echo e(number_format($order->tax_amount, 2)); ?></td>
                                </tr>
                            <?php endif; ?>
                            <?php if($order->discount_amount > 0): ?>
                                <tr>
                                    <td style="color: #dc2626;">Discount</td>
                                    <td class="text-right" style="color: #dc2626;">
                                        -<?php echo e(number_format($order->discount_amount, 2)); ?></td>
                                </tr>
                            <?php endif; ?>

                            <tr class="final-row">
                                <td>Total</td>
                                <td class="text-right">Rs. <?php echo e(number_format($order->net_amount, 2)); ?></td>
                            </tr>

                            <?php if($order->paid_amount > 0): ?>
                                <tr>
                                    <td style="padding-top: 2px; color: #16a34a;">Less: Paid</td>
                                    <td class="text-right" style="padding-top: 2px; color: #16a34a;">
                                        -<?php echo e(number_format($order->paid_amount, 2)); ?></td>
                                </tr>
                            <?php endif; ?>

                            <?php if(($order->net_amount - $order->paid_amount) > 0): ?>
                                <tr>
                                    <td style="font-weight: 700; color: #dc2626;">Balance Due</td>
                                    <td class="text-right" style="font-weight: 700; color: #dc2626;">
                                        <?php echo e(number_format($order->net_amount - $order->paid_amount, 2)); ?>

                                    </td>
                                </tr>
                            <?php endif; ?>
                        </table>

                        <div style="margin-top: 30px; text-align: right;">
                            <div
                                style="display: inline-block; border-top: 1px solid #0f172a; width: 150px; text-align: center; font-size: 8px; font-weight: 700;">
                                AUTHORIZED SIGNATORY
                            </div>
                        </div>
                    </td>
                </tr>
            </table>
        </div>

    </div>
</body>

</html><?php /**PATH /home/fieldtrack/public_html/maatrader-api.fieldtrack.in/resources/views/invoices/pdf.blade.php ENDPATH**/ ?>