<?php

use App\Models\BankAccount;
use Illuminate\Support\Facades\DB;

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "Starting Test...\n";

// 1. Create two test accounts
$acc1 = BankAccount::create([
    'bank_name' => 'Test Bank 1',
    'account_name' => 'Test User 1',
    'account_number' => '1234567890',
    'ifsc_code' => 'TEST0001',
    'upi_id' => 'test1@upi',
    'is_default' => false
]);

$acc2 = BankAccount::create([
    'bank_name' => 'Test Bank 2',
    'account_name' => 'Test User 2',
    'account_number' => '0987654321',
    'ifsc_code' => 'TEST0002',
    'upi_id' => 'test2@upi',
    'is_default' => false
]);

echo "Created Accounts: {$acc1->id}, {$acc2->id}\n";

// 2. emulate logic to set acc1 as default
echo "Setting Acc1 ({$acc1->id}) as default...\n";
DB::transaction(function () use ($acc1) {
    BankAccount::where('id', '!=', $acc1->id)->update(['is_default' => false]);
    $acc1->is_default = true;
    $acc1->save();
});

// Verify
$acc1 = BankAccount::find($acc1->id);
$acc2 = BankAccount::find($acc2->id);

echo "Acc1 Default: " . ($acc1->is_default ? 'YES' : 'NO') . "\n";
echo "Acc2 Default: " . ($acc2->is_default ? 'YES' : 'NO') . "\n";

if (!$acc1->is_default)
    echo "ERROR: Acc1 should be default\n";

// 3. emulate logic to set acc2 as default
echo "Setting Acc2 ({$acc2->id}) as default (Logic from Controller)...\n";
DB::transaction(function () use ($acc2) {
    BankAccount::where('id', '!=', $acc2->id)->update(['is_default' => false]);
    $acc2->is_default = true;
    $acc2->save();
});

// Verify
$acc1 = BankAccount::find($acc1->id); // Re-fetch
$acc2 = BankAccount::find($acc2->id); // Re-fetch

echo "Acc1 Default: " . ($acc1->is_default ? 'YES' : 'NO') . "\n";
echo "Acc2 Default: " . ($acc2->is_default ? 'YES' : 'NO') . "\n";

if ($acc1->is_default)
    echo "ERROR: Acc1 should NOT be default\n";
if (!$acc2->is_default)
    echo "ERROR: Acc2 should be default\n";

// Cleanup
$acc1->forceDelete();
$acc2->forceDelete();
echo "Test Complete.\n";
