<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->date('expense_date');
            $table->string('category'); // Rent, Salary, Bills, Maintenance, Other
            $table->decimal('amount', 15, 2);
            $table->text('description')->nullable();
            $table->string('payment_method')->default('Cash'); // Cash, Bank Transfer, UPI, Cheque
            $table->string('reference_no')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('expenses');
    }
};
