<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\SalesOrderItem;

return new class extends Migration {
    public function up(): void
    {
        // Backfill sub_size_name from the linked batch
        SalesOrderItem::whereNull('sub_size_name')
            ->chunkById(100, function ($items) {
                foreach ($items as $item) {
                    if ($item->batch && $item->batch->subSize) {
                        $item->update([
                            'sub_size_name' => $item->batch->subSize->name
                        ]);
                    }
                }
            });
    }

    public function down(): void
    {
        // No down needed as we are just backfilling data
    }
};
