<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales_order_items', function (Blueprint $table) {
            $table->decimal('total_weight_kg', 10, 2)->nullable()->change();
        });

        Schema::table('sales_returns', function (Blueprint $table) {
            $table->decimal('weight_kg', 10, 2)->nullable()->change();
        });

        Schema::table('sales_damages', function (Blueprint $table) {
            $table->decimal('weight_kg', 10, 2)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales_order_items', function (Blueprint $table) {
            $table->decimal('total_weight_kg', 10, 2)->nullable(false)->change();
        });

        Schema::table('sales_returns', function (Blueprint $table) {
            $table->decimal('weight_kg', 10, 2)->nullable(false)->change();
        });

        Schema::table('sales_damages', function (Blueprint $table) {
            $table->decimal('weight_kg', 10, 2)->nullable(false)->change();
        });
    }
};
