<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('stock_batches', function (Blueprint $table) {
            $table->id();
            $table->string('batch_no')->unique();
            $table->string('category'); // RAW_MATERIAL, FINISHED_GOOD
            $table->foreignId('size_id')->constrained();
            $table->foreignId('sub_size_id')->nullable()->constrained();

            $table->string('source_type'); // PURCHASE, PRODUCTION
            $table->unsignedBigInteger('source_id')->nullable();

            // Core metrics
            $table->integer('bundles_count')->nullable();
            $table->integer('pieces_per_bundle')->nullable();
            $table->integer('total_pieces')->nullable();
            $table->decimal('total_weight_kg', 10, 2);

            // Derived
            $table->decimal('weight_per_bundle_kg', 10, 2)->nullable();
            $table->decimal('weight_per_piece_kg', 10, 3)->nullable();

            // Available State
            $table->integer('available_pieces')->nullable();
            $table->decimal('available_weight_kg', 10, 2);

            // Costing
            $table->decimal('cost_per_piece', 10, 2)->default(0);
            $table->decimal('cost_per_kg', 10, 2)->default(0);

            $table->string('status')->default('ACTIVE'); // ACTIVE, CLOSED
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('stock_batches');
    }
};
