<?php

namespace App\Services;

use App\Models\AuditLog;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;

class AuditService
{
    public static function log($action, $module, $description, $model = null, $metadata = [])
    {
        // Don't log if running in console (unless needed) or if disabled

        $userId = Auth::id(); // Might be null for system actions or login (will handle login separately)

        // If Model provided, extract type and id
        $resourceType = null;
        $resourceId = null;

        if ($model) {
            $resourceType = get_class($model);
            $resourceId = $model->id;
        }

        AuditLog::create([
            'user_id' => $userId,
            'action' => $action,
            'module' => $module,
            'description' => $description,
            'resource_type' => $resourceType,
            'resource_id' => $resourceId,
            'metadata' => $metadata,
            'ip_address' => Request::ip()
        ]);
    }
}
