<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingsSeeder extends Seeder
{
    public function run(): void
    {
        $defaults = [
            ['key' => 'company_name', 'value' => 'Maa Trader', 'group' => 'company'],
            ['key' => 'company_address', 'value' => 'Orma Highway, Siwan - 841236', 'group' => 'company'],
            ['key' => 'company_phone', 'value' => '+91 99999 99999', 'group' => 'company'],
            ['key' => 'company_gst', 'value' => 'XXXXXXXXX', 'group' => 'company'],
        ];

        foreach ($defaults as $data) {
            Setting::firstOrCreate(
                ['key' => $data['key']],
                $data
            );
        }
    }
}
