<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(10)->create();

        // Prevent duplicate entry error if running 'db:seed' multiple times without fresh
        if (!User::where('email', 'admin@maa-trader.com')->exists()) {
            User::factory()->create([
                'name' => 'Admin User',
                'email' => 'admin@maa-trader.com',
                'password' => Hash::make('password'),
                'role' => 'ADMIN',
            ]);
        }

        if (!User::where('email', 'sales@maa-trader.com')->exists()) {
            User::factory()->create([
                'name' => 'Sales User',
                'email' => 'sales@maa-trader.com',
                'password' => Hash::make('password'),
                'role' => 'SALESMAN',
            ]);
        }
    }
}
