<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales_returns', function (Blueprint $table) {
            $table->string('return_no')->after('id')->nullable();
        });

        Schema::table('sales_damages', function (Blueprint $table) {
            $table->string('damage_no')->after('id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales_returns', function (Blueprint $table) {
            $table->dropColumn('return_no');
        });

        Schema::table('sales_damages', function (Blueprint $table) {
            $table->dropColumn('damage_no');
        });
    }
};
