<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('sales_order_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sales_order_id')->constrained()->cascadeOnDelete();

            $table->foreignId('batch_id')->constrained('stock_batches');
            $table->string('batch_no'); // Snapshot
            $table->string('size_name'); // Snapshot

            $table->integer('quantity_bundles')->nullable();
            $table->integer('quantity_pieces');
            $table->decimal('total_weight_kg', 10, 2);

            $table->decimal('price_per_kg', 10, 2);
            $table->decimal('total_price', 12, 2);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sales_order_items');
    }
};
