<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BankAccount extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'bank_name',
        'account_name',
        'account_number',
        'ifsc_code',
        'upi_id',
        'is_default',
    ];

    protected $casts = [
        'is_default' => 'boolean',
    ];

    protected static function booted()
    {
        static::saving(function ($account) {
            if ($account->is_default && $account->isDirty('is_default')) {
                static::where('id', '!=', $account->id)->update(['is_default' => false]);
            }
        });
    }
}
